<?php
/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
*/

use Cart\Cart;

/**
* Model class
 *
 * @property Cart $cart
 * @property Config $config
 * @property DB $db
 * @property Session $session
 * @property Language $language
 * @property ModelSettingExtension $model_setting_extension
 * @property ModelCheckoutOrder $model_checkout_order
*/
abstract class Model {
	protected $registry;

	public function __construct($registry) {
		$this->registry = $registry;
	}

	public function __get($key) {
		return $this->registry->get($key);
	}

	public function __set($key, $value) {
		$this->registry->set($key, $value);
	}
}