<?php
/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
*/

/**
* Router class
*/
final class Router {
	private $registry;
	private $pre_action = array();
	private $error;
	
	/**
	 * Constructor
	 *
	 * @param	object	$route
 	*/

        private function runAction($actionName) {
          // added in defensive checks to ensure the
          // controller class is available and accessible
          try {
            if (is_file(
              DIR_APPLICATION . '/controller/' . $actionName . '.php')) {
              $facebookAction = new Action($actionName);
              $facebookAction->execute($this->registry);
            }
          } catch (Exception $e) {
            error_log($e->getMessage());
          }
        }
      
	public function __construct($registry) {
		$this->registry = $registry;
	}
	
	/**
	 * 
	 *
	 * @param	object	$pre_action
 	*/	
	public function addPreAction(Action $pre_action) {
		$this->pre_action[] = $pre_action;
	}

	/**
	 * 
	 *
	 * @param	object	$action
	 * @param	object	$error
 	*/		
	public function dispatch(Action $action, Action $error) {

        // tracking the last pre_action in the list
        $lastPreAction = end($this->pre_action);
      
		$this->error = $error;

		foreach ($this->pre_action as $pre_action) {
			$result = $this->execute($pre_action);

        // additional attempt to extract the pixel details after
        // executing the last preaction on the list of pre-actions
        // we have to wait for all the preactions to be executed as 
        // only then all the required information will be ready, eg
        // uri mapping, shopping cart
        if (isset($lastPreAction) && $pre_action == $lastPreAction) {
          $this->runAction('extension/facebookeventparameters');
        }
      

			if ($result instanceof Action) {
				$action = $result;

				break;
			}
		}


        // redirecting the direct checkout URL to product details page
        $this->runAction('extension/facebookpageshopcheckoutredirect');

        // building up the information for pixel firing
        $this->runAction('extension/facebookeventparameters');
      
		while ($action instanceof Action) {
			$action = $this->execute($action);
		}
	}
	
	/**
	 * 
	 *
	 * @param	object	$action
	 * @return	object
 	*/
	private function execute(Action $action) {
		$result = $action->execute($this->registry);

		if ($result instanceof Action) {
			return $result;
		} 
		
		if ($result instanceof Exception) {
			$action = $this->error;
			
			$this->error = null;
			
			return $action;
		}
	}
}