<?php
class ControllerCommonFooter extends Controller {
	public function index() {
 
                $this->load->model('extension/module/netreviews');
                $current_language_id = $this->config->get('config_language_id'); 
                $current_store_id = $this->config->get('config_store_id');
                $is_configured = $this->model_extension_module_netreviews->isConfigured($current_store_id, $current_language_id);
                $data['is_configured'] = $is_configured;
                $display_script_float = null;
                $display_script_float = $this->model_extension_module_netreviews->get_attribute($current_store_id, $current_language_id,"SCRIPTFLOAT_ALLOWED");
                $data['display_script_float'] = $display_script_float;
                if($is_configured){
                    $id_website = $this->model_extension_module_netreviews->get_attribute($current_store_id, $current_language_id,"ID_WEBSITE");
                    $secret_key = $this->model_extension_module_netreviews->get_attribute($current_store_id, $current_language_id,"SECRET_KEY");
                    $platform_code = $this->model_extension_module_netreviews->get_attribute($current_store_id, $current_language_id,"PLATFORM_CODE");

                    $data['id_website'] = $id_website;
                    $data['secret_key'] = $secret_key;
                    $data['platform_code'] = $platform_code;

                    $data['idwebsite_first_char'] = $id_website[0];
                    $data['idwebsite_second_char'] = $id_website[1];
                    $data['idwebsite_third_char'] = $id_website[2];
                    $data['netreviews_floating_widget'] = $this->model_extension_module_netreviews->get_attribute($current_store_id, $current_language_id,"SCRIPTFLOAT");
                    $data['netreviews_floating_widget'] = $this->model_extension_module_netreviews->AV_decode_base64($data['netreviews_floating_widget']);
                } 
		$this->load->language('common/footer');

		$this->load->model('catalog/information');

		$data['informations'] = array();

		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
		}

		$data['contact'] = $this->url->link('information/contact');
		$data['return'] = $this->url->link('account/return/add', '', true);
		$data['sitemap'] = $this->url->link('information/sitemap');
		$data['tracking'] = $this->url->link('information/tracking');
		$data['manufacturer'] = $this->url->link('product/manufacturer');
		$data['voucher'] = $this->url->link('account/voucher', '', true);
		$data['affiliate'] = $this->url->link('affiliate/login', '', true);
		$data['special'] = $this->url->link('product/special');
		$data['account'] = $this->url->link('account/account', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);

				$data['block3'] = $this->load->controller('common/block3');				
				$data['block4'] = $this->load->controller('common/block4');								
			

		$data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('config_name'), date('Y', time()));

		// Whos Online
		if ($this->config->get('config_customer_online')) {
			$this->load->model('tool/online');

			if (isset($this->request->server['REMOTE_ADDR'])) {
				$ip = $this->request->server['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
				$url = ($this->request->server['HTTPS'] ? 'https://' : 'http://') . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
			} else {
				$url = '';
			}

			if (isset($this->request->server['HTTP_REFERER'])) {
				$referer = $this->request->server['HTTP_REFERER'];
			} else {
				$referer = '';
			}

			$this->model_tool_online->addOnline($ip, $this->customer->getId(), $url, $referer);
		}

		$data['scripts'] = $this->document->getScripts('footer');
		
		return $this->load->view('common/footer', $data);
	}
}
