<?php
class ControllerAccountNewsletter extends Controller {
	public function index() {
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/newsletter', '', true);

			$this->response->redirect($this->url->link('account/login', '', true));
		}

		$this->load->language('account/newsletter');

		$this->document->setTitle($this->language->get('heading_title'));

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			$this->load->model('account/customer');

			$this->model_account_customer->editNewsletter($this->request->post['newsletter']);

		  	//Mailchimp add customer
			$post = $this->request->post;
			$api_key = '00332c2b4cd2584d1de3bb26fa624b3b-us19';
			$list_id = '34625f49e8';

			$data = [
				'apikey'        => $api_key,
				'email_address' => $post['email'],
				'status'        => $post['newsletter'] == 1 ? 'subscribed' : 'unsubscribed',
				'merge_fields'  => [
					'FNAME' => $post['firstname'],
					'LNAME' => $post['lastname'],
					'LPHONE' => $post['telephone']
				]
			];
			$mch_api = curl_init(); // initialize cURL connection

			curl_setopt($mch_api, CURLOPT_URL, 'https://' . substr($api_key,strpos($api_key,'-')+1) . '.api.mailchimp.com/3.0/lists/' . $list_id . '/members/' . md5(strtolower($post['email'])));
			curl_setopt($mch_api, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: apikey ' . $api_key));
			curl_setopt($mch_api, CURLOPT_USERAGENT, 'PHP-MCAPI/2.0');
			curl_setopt($mch_api, CURLOPT_RETURNTRANSFER, true); // return the API response
			curl_setopt($mch_api, CURLOPT_CUSTOMREQUEST, 'PUT'); // method PUT
			curl_setopt($mch_api, CURLOPT_TIMEOUT, 10);
			curl_setopt($mch_api, CURLOPT_POST, true);
			curl_setopt($mch_api, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($mch_api, CURLOPT_POSTFIELDS, json_encode($data) ); // send data in json

			curl_exec($mch_api);
		

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('account/account', '', true));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_newsletter'),
			'href' => $this->url->link('account/newsletter', '', true)
		);

		$data['action'] = $this->url->link('account/newsletter', '', true);

		$data['newsletter'] = $this->customer->getNewsletter();

		$data['back'] = $this->url->link('account/account', '', true);

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		$this->response->setOutput($this->load->view('account/newsletter', $data));
	}
}