<?php

class ModelExtensionModuleOcLayeredNavigation extends Model
{
    public function getMinMaxPrice($cat_id)
    {
        $sql = "SELECT MIN(p.price) AS min, MAX(p.price) AS max  FROM " . DB_PREFIX . "product AS p inner join " . DB_PREFIX . "product_to_category AS cat on cat.product_id = p.product_id AND cat.category_id='" . $cat_id . "' WHERE p.status = 1 AND p.quantity>0";
        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getManufacturerMinMaxPrice($manufacturer_id)
    {
        $sql = "SELECT MIN(p.price) AS min, MAX(p.price) AS max  FROM " . DB_PREFIX . "product AS p  WHERE p.status = 1 AND p.quantity>0 AND p.manufacturer_id='" . $manufacturer_id . "'";
        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getAllOptions($product_id)
    {
        $product_id = implode(",", array_map('intval', $product_id));
        $sql = "SELECT DISTINCT pov.option_value_id, od.name AS option_name,ovd.name AS opt_value_name, o.option_id 
        FROM " . DB_PREFIX . "product_option_value AS pov 
        LEFT JOIN " . DB_PREFIX . "option_value AS ov ON pov.option_id = ov.option_id AND pov.option_value_id = ov.option_value_id 
        LEFT JOIN " . DB_PREFIX . "option_value_description AS ovd ON pov.option_id = ovd.option_id AND pov.option_value_id = ovd.option_value_id 
        LEFT JOIN " . DB_PREFIX . "product_option AS po ON pov.option_id = po.option_id AND pov.product_id = po.product_id 
        LEFT JOIN " . DB_PREFIX . "option_description AS od ON pov.option_id = od.option_id 
        LEFT JOIN " . DB_PREFIX . "option AS o ON pov.option_id = o.option_id 
        WHERE pov.product_id IN (" . $product_id . ") AND po.required = '1' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "' AND pov.quantity > 0
        order by ov.sort_order ASC";
        $query = $this->db->query($sql);
        $option_data = array();
        foreach ($query->rows as $item) {
            $option_data[$item['option_name']][] = array(
                'filter_id' => $item['option_value_id'],
                'name' => $item['opt_value_name'],
            );
        }
        return $option_data;
    }


    public function getAllManufacturerId($product_id)
    {
        $product_id = implode(",", array_map('intval', $product_id));

        $query = $this->db->query("SELECT DISTINCT p.manufacturer_id, m.name AS manu_name 
        FROM " . DB_PREFIX . "product AS p 
        LEFT JOIN " . DB_PREFIX . "manufacturer AS m ON p.manufacturer_id = m.manufacturer_id 
        WHERE p.product_id IN (" . $product_id . ") AND p.manufacturer_id != '0' 
        ORDER BY m.sort_order ASC");
        $manu_data = array();
        foreach ($query->rows as $item) {
            $manu_data[] = array(
                'filter_id' => $item['manufacturer_id'],
                'name' => $item['manu_name'],
            );
        }
        return $manu_data;
    }

}