<?phpclass ModelBlogArticle extends Model {    public function addArticle($data) {        $this->db->query("INSERT INTO " . DB_PREFIX . "article SET author = '" . $this->db->escape($data['author']) . "', image = '" . $this->db->escape($data['image']) . "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");		$article_id = $this->db->getLastId();        		foreach ($data['article_description'] as $language_id => $value) {			$this->db->query("INSERT INTO " . DB_PREFIX . "article_description SET article_id = '" . (int)$article_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', intro_text = '" . $this->db->escape($value['intro_text']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");		}		if (isset($data['keyword'])) {			$this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET query = 'article_id=" . (int)$article_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");		}		if (isset($data['article_store'])) {			foreach ($data['article_store'] as $store_id) {				$this->db->query("INSERT INTO " . DB_PREFIX . "article_to_store SET article_id = '" . (int)$article_id . "', store_id = '" . (int)$store_id . "'");			}		}		$this->cache->delete('article');		return $article_id;	}	public function editArticle($article_id, $data) {		$this->db->query("UPDATE " . DB_PREFIX . "article SET author = '" . $this->db->escape($data['author']) . "', image = '" . $this->db->escape($data['image']) . "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', date_modified = NOW() WHERE article_id = '" . (int)$article_id . "'");		$this->db->query("DELETE FROM " . DB_PREFIX . "article_description WHERE article_id = '" . (int)$article_id . "'");		foreach ($data['article_description'] as $language_id => $value) {			$this->db->query("INSERT INTO " . DB_PREFIX . "article_description SET article_id = '" . (int)$article_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', intro_text = '" . $this->db->escape($value['intro_text']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");		}		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'article_id=" . (int)$article_id . "'");		if ($data['keyword']) {			$this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET query = 'article_id=" . (int)$article_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");		}		$this->db->query("DELETE FROM " . DB_PREFIX . "article_to_store WHERE article_id = '" . (int)$article_id . "'");		if (isset($data['article_store'])) {			foreach ($data['article_store'] as $store_id) {				$this->db->query("INSERT INTO " . DB_PREFIX . "article_to_store SET article_id = '" . (int)$article_id . "', store_id = '" . (int)$store_id . "'");			}		}		$this->cache->delete('article');	}	public function copyArticle($article_id) {		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "article a LEFT JOIN " . DB_PREFIX . "article_description ad ON (a.article_id = ad.article_id) WHERE a.article_id = '" . (int)$article_id . "' AND ad.language_id = '" . (int)$this->config->get('config_language_id') . "'");		if ($query->num_rows) {			$data = array();			$data = $query->row;            $data['status'] = '0';			$data = array_merge($data, array('article_description' => $this->getArticleDescriptions($article_id)));			$this->addArticle($data);		}	}	public function deleteArticle($article_id) {		$this->db->query("DELETE FROM " . DB_PREFIX . "article WHERE article_id = '" . (int)$article_id . "'");		$this->db->query("DELETE FROM " . DB_PREFIX . "article_description WHERE article_id = '" . (int)$article_id . "'");		$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'article_id=" . (int)$article_id . "'");		$this->cache->delete('article');	}	public function getArticle($article_id) {		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "seo_url WHERE query = 'article_id=" . (int)$article_id . "') AS keyword FROM " . DB_PREFIX . "article a LEFT JOIN " . DB_PREFIX . "article_description ad ON (a.article_id = ad.article_id) WHERE a.article_id = '" . (int)$article_id . "' AND ad.language_id = '" . (int)$this->config->get('config_language_id') . "'");		return $query->row;	}	public function getArticleStores($article_id) {		$article_store_data = array();		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "article_to_store WHERE article_id = '" . (int)$article_id . "'");		foreach ($query->rows as $result) {			$article_store_data[] = $result['store_id'];		}		return $article_store_data;	}	public function getArticles($data = array()) {		$sql = "SELECT * FROM " . DB_PREFIX . "article a LEFT JOIN " . DB_PREFIX . "article_description ad ON (a.article_id = ad.article_id) WHERE ad.language_id = '" . (int)$this->config->get('config_language_id') . "'";		if (!empty($data['filter_name'])) {			$sql .= " AND ad.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";		}		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {			$sql .= " AND a.status = '" . (int)$data['filter_status'] . "'";		}				$sql .= " GROUP BY a.article_id";		$sort_data = array(			'ad.name',			'a.status',			'a.sort_order'		);		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {			$sql .= " ORDER BY " . $data['sort'];		} else {			$sql .= " ORDER BY ad.name";		}		if (isset($data['order']) && ($data['order'] == 'DESC')) {			$sql .= " DESC";		} else {			$sql .= " ASC";		}		if (isset($data['start']) || isset($data['limit'])) {			if ($data['start'] < 0) {				$data['start'] = 0;			}			if ($data['limit'] < 1) {				$data['limit'] = 20;			}			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];		}		$query = $this->db->query($sql);		return $query->rows;	}	public function getArticleDescriptions($article_id) {		$article_description_data = array();		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "article_description WHERE article_id = '" . (int)$article_id . "'");		foreach ($query->rows as $result) {			$article_description_data[$result['language_id']] = array(				'name'             => $result['name'],				'description'      => $result['description'],				'meta_title'       => $result['meta_title'],				'meta_description' => $result['meta_description'],				'meta_keyword'     => $result['meta_keyword'],				'intro_text'       => $result['intro_text']			);		}		return $article_description_data;	}	public function getTotalArticles($data = array()) {		$sql = "SELECT COUNT(DISTINCT a.article_id) AS total FROM " . DB_PREFIX . "article a LEFT JOIN " . DB_PREFIX . "article_description ad ON (a.article_id = ad.article_id)";		$sql .= " WHERE ad.language_id = '" . (int)$this->config->get('config_language_id') . "'";		if (!empty($data['filter_name'])) {			$sql .= " AND ad.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";		}		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {			$sql .= " AND a.status = '" . (int)$data['filter_status'] . "'";		}		$query = $this->db->query($sql);		return $query->row['total'];	}}