<?php

class ControllerExtensionModuleMfspromotions extends Controller
{
    private $error = array();
    private $data = array();

    public function index() {
        // Load language
        $this->load->language('extension/module/mfs_promotions');
        $data['objlang'] = $this->language;

        // Load breadcrumbs
        $data['breadcrumbs'] = $this->_breadcrumbs();

        // Load model
        $this->load->model('catalog/category');
        $this->load->model('extension/module');
        $this->load->model('extension/module/mfs_promotions');
        $this->load->model('tool/image');

        $this->document->setTitle($this->language->get('heading_title'));
        // Get data
        $model = $this->model_extension_module_mfs_promotions;
        $model->checkInstall();

        // Delete Module
        if (isset($this->request->get['slide_id']) && isset($this->request->get['module_id']) && isset($this->request->get['delete'])) {
            $this->model_extension_module_mfs_promotions->deleteSlide($this->request->get['slide_id']);
            $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&tab=slide&module_id=' . $this->request->get['module_id'], 'SSL'));
        } elseif (!isset($this->request->get['slide_id']) && isset($this->request->get['module_id']) && isset($this->request->get['delete'])) {
            $this->model_extension_module->deleteModule($this->request->get['module_id']);
            $this->model_extension_module_mfs_promotions->deleteAllSlide($this->request->get['module_id']);
            $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'], 'SSL'));
        }

        // Get Module Id New
        $moduleid_new = $this->model_extension_module_mfs_promotions->getModuleId(); // Get module id
        $slideid_new = $this->model_extension_module_mfs_promotions->getSlideId(); // Get slide id

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            $tab_module = isset($this->request->post["tab_module"]) ? $this->request->post["tab_module"] : "";
            unset($this->request->post['tab_module']);
            $tab = isset($this->request->get["tab"]) ? $this->request->get["tab"] : "";

            $action = isset($this->request->post["action"]) ? $this->request->post["action"] : "";
            unset($this->request->post['action']);
            if ($tab_module == 'add-slide' || $tab == 'slide' && $tab_module != 'add-module') {
                if (!isset($this->request->get['slide_id'])) {
                    $this->request->post['slideid'] = $slideid_new[0]['Auto_increment'];
                    $slide_id = $slideid_new[0]['Auto_increment'];
                    $this->request->post['moduleid'] = $this->request->get['module_id'];
                    $this->model_extension_module_mfs_promotions->addSlide($this->request->post);
                } else {
                    $slide_id = $this->request->get['slide_id'];
                    $this->request->post['moduleid'] = $this->request->get['module_id'];

                    $this->model_extension_module_mfs_promotions->editSlide($this->request->get['slide_id'], $this->request->post);
                }

                if ($action == "save_edit") {
                    $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'module_id=' . $this->request->get['module_id'] . '&tab=slide&slide_id=' . $slide_id . '&user_token=' . $this->session->data['user_token'], 'SSL'));
                } elseif ($action == "save_new") {
                    $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&tab=slide&module_id=' . $this->request->get['module_id'], 'SSL'));
                } else {
                    $this->response->redirect($this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                }
            } else {
                if (!isset($this->request->get['module_id'])) {
                    $this->request->post['moduleid'] = $moduleid_new[0]['Auto_increment'];
                    $module_id = $moduleid_new[0]['Auto_increment'];
                    $this->model_extension_module->addModule('mfs_promotions', $this->request->post);

                } else {
                    $module_id = $this->request->get['module_id'];
                    $this->request->post['moduleid'] = $this->request->get['module_id'];
                    $this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
                }
                $data = $this->request->post;

                $this->session->data['success'] = $this->language->get('text_success');
                if ($action == "save_edit") {
                    $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'module_id=' . $module_id . '&user_token=' . $this->session->data['user_token'], 'SSL'));
                } elseif ($action == "save_new") {
                    $this->response->redirect($this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                } else {
                    $this->response->redirect($this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                }
            }
        }

        $data['cancel'] = $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], 'SSL');

        $default = array(
            'name' => '',
            'module_description' => array(),
            'status' => '1',
        );

        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();

        if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST') || ($this->request->server['REQUEST_METHOD'] == 'POST' && !$this->validate() && isset($this->request->get['module_id'])) || ($this->request->server['REQUEST_METHOD'] == 'POST' && !$this->validate() && isset($this->request->get['slide_id']))) {
            $module_info = $default;
            $info_save = $this->model_extension_module->getModule($this->request->get['module_id']);
            $module_info = array_merge($module_info, $info_save);
            $module_info['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);

            $data['action'] = $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], 'SSL');

            if (isset($this->request->get['slide_id'])) {
                $data['action'] = $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&tab=slide&module_id=' . $this->request->get['module_id'] . '&slide_id=' . $this->request->get['slide_id'], 'SSL');

            } elseif (isset($this->request->get['tab']) && $this->request->get['tab'] == "slide") {
                $data['action'] = $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&tab=slide&module_id=' . $this->request->get['module_id'], 'SSL');
            }
            $data['subheading'] = $this->language->get('text_edit_module') . $module_info['name'];
            $data['selectedid'] = $this->request->get['module_id'];
            $data['slide_description'] = array(
                'status' => '1'
            );


            if (isset($this->request->get['slide_id'])) {
                $data['slide_description'] = $this->model_extension_module_mfs_promotions->getSliderById($this->request->get['slide_id']);
                $language = count($data['slide_description']);
                $language_id = (int)$this->config->get('config_language_id');
                $data['slide_description']['url'] = $data['slide_description'][$language_id]['url'];
                $data['slide_description']['status'] = $data['slide_description'][$language_id]['status'];
            }
            if ($this->request->post != null) {
                foreach ($this->request->post['slide_description'] as $item) {
                    $data['slide_description'][$item['language_id']] = array(
                        'title' => $item['slide_title'],
                        'description' => $item['slide_description']
                    );
                }
                $data['slide_description']['url'] = $this->request->post['slide_link'];
                $data['slide_description']['status'] = $this->request->post['slide_status'];
            }

        } else {
            $module_info = $default;
            if ($this->request->post != null) {
                $module_info = array_merge($module_info, $this->request->post);
            }

            $data['selectedid'] = 0;
            $data['action'] = $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'], 'SSL');
            $data['subheading'] = $this->language->get('text_create_new_module');
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['error'] = $this->error;
        // Save and Stay --------------------------------------------------------------
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        $data['text_layout'] = sprintf($this->language->get('text_layout'), $this->url->link('design/layout', 'user_token=' . $this->session->data['user_token'], 'SSL'));

        // ---------------------------Load module --------------------------------------------
        $data['module'] = $module_info;

        $data['moduletabs'] = $this->model_extension_module->getModulesByCode('mfs_promotions');
        $data['link'] = $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '', 'SSL');
        $data['linkremove'] = $this->url->link('extension/module/mfs_promotions&user_token=' . $this->session->data['user_token']);
        //--------------------------------Load Data -------------------------------------------
        $data['item_link_targets'] = array(
            '_blank' => $this->language->get('value_blank'),
            '_self' => $this->language->get('value_self'),
        );


        //button page
        $data['button_pages'] = array(
            'top' => $this->language->get('value_top'),
            'under' => $this->language->get('value_under'),
        );

        // Module description
        $data['module_description'] = $module_info['module_description'];
        // List slide
        $data['slides'] = array();

        if (isset($module_info['moduleid'])) {
            $data['slides'] = $model->getListSliderGroups($module_info['moduleid']);
        }
        //Get Data Default
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        // Remove cache
        $data['success_remove'] = $this->language->get('text_success_remove');
        $is_ajax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
        $data['_GET'] = $_GET;
        $this->response->setOutput($this->load->view('extension/module/mfs_promotions', $data));
    }

    public function _breadcrumbs() {
        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        if (!isset($this->request->get['module_id'])) {
            $this->data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'], 'SSL')
            );
        } else {
            $this->data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/mfs_promotions', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], 'SSL')
            );
        }
        return $this->data['breadcrumbs'];
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/mfs_promotions')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
            $this->error['name'] = $this->language->get('error_name');
        }

        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();

        foreach ($languages as $language) {
            if (isset($this->request->post['module_description'])) {
                $module_description = $this->request->post['module_description'];
                if ((utf8_strlen($module_description[$language['language_id']]['head_name']) < 3) || (utf8_strlen($module_description[$language['language_id']]['head_name']) > 64)) {
                    $this->error['head_name'] = $this->language->get('error_head_name');
                }
            }
            if (isset($this->request->post['slide_description']) && $this->request->post['tab_module'] == 'add-slide' || isset($this->request->post['slide_description']) && isset($this->request->get['tab']) && ($this->request->get['tab'] == "slide") && isset($this->request->post['slide_description']) && $this->request->post['tab_module'] == '') {
                $slide_description = $this->request->post['slide_description'];
                if ((utf8_strlen($slide_description[$language['language_id']]['slide_title']) < 1)) {
                    $this->error['slide_title'] = $this->language->get('error_slide_title');
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }
        return !$this->error;
    }

    public function sortposition() {
        $json = array();
        $this->load->model('extension/module/mfs_promotions');
        if (isset($this->request->get['sortarray'])) {
            $result = $this->model_extension_module_mfs_promotions->updatePositionSlide($this->request->get['sortarray']);
        }
    }
}